######This is to compute the early exercise premium (eep) for a given exercise boundary and transition density   ########################
eep<-function(x,beta,Ts,sigma,r,delta,tau,B1,B2,K,type){
  ##### x, beta, Ts, Sigma, tau: are elements to compute the RND
  ##### rf: risk free rate
  ##### st: spot price of the underlying at time=1
  ##### B1, B2: values of the exercise boundary at time=1 and time=2
  ##### tau: time length between time=1 and time=2
  ##### K: strike
  
  if (B1<1e-5)
  {B1<-1e-5}
  st<-B1
  if (type=="P") {
    lth<-length(x*sigma*sqrt(tau))

    ST  <- exp(x*sigma*sqrt(tau) + rep(r*tau + log(st),lth))
    RND_ST <- t(Ts) %*% beta / (sigma*sqrt(tau)*ST)
    pos<-which(ST<=B2)
    STK<-ST[pos]
    RND_STK<-RND_ST[pos]
    if (length(STK)>=2){
      dST<-STK[2:length(STK)]-STK[1:(length(STK)-1)]
      eep1<-((exp(-r*tau)*(r*K-delta*STK[2:length(STK)])*RND_STK[2:length(RND_STK)]) %*% dST)[1]
      eep2<-((exp(-r*tau)*(r*K-delta*STK[1:(length(STK)-1)])*RND_STK[1:(length(RND_STK)-1)]) %*% dST)[1]
      eep<-(eep1+eep2)/2
    }else if (length(STK)==1) {
      eep<-(((r*K-delta*STK)*exp(-r*tau)*RND_STK) %*% (K-STK))[1]
    }else if (length(STK)==0) {
      eep<-0
    }
  }else if (type=="C") {
    lth<-length(x*sigma*sqrt(tau))
    ST  <- exp(x*sigma*sqrt(tau) + rep(r*tau + log(st),lth))
    RND_ST <- t(Ts) %*% beta / (sigma*sqrt(tau)*ST)
    pos<-which(ST>=B2)
    STK<-ST[pos]
    RND_STK<-RND_ST[pos]
    if (length(STK)>=2){
      dST<-STK[2:length(STK)]-STK[1:(length(STK)-1)]
      eep1<-(((delta*STK[2:length(STK)]-r*K)*exp(-r*tau)*RND_STK[2:length(RND_STK)]) %*% dST)[1]
      eep2<-(((delta*STK[1:(length(STK)-1)]-r*K)*exp(-r*tau)*RND_STK[1:(length(RND_STK)-1)]) %*% dST)[1]
      eep<-(eep1+eep2)/2
    }else if (length(STK)==1) {
      eep<-(((delta*STK-r*K)*exp(-r*tau)*RND_STK) %*% (STK-K))[1]
    }else if (length(STK)==0) {
      eep<-0
    }
  }
  return(eep)
}


EEP<-function(x,beta,Ts,sigma,r,delta,st,B,K,type){
  EEP<-0
  for (q in seq((0),(M),1)){
    EEP<-EEP+eep(x,beta,Ts,sigma,r,delta,(q)*Delta,st,B[q],K,type)*Delta
  }
  return(EEP)
}